<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use SergiX44\Nutgram\Telegram\Properties\MessageType;

class Asset extends Model
{
    protected $fillable = ['folder_id', 'type', 'file_id', 'title', 'metadata', 'position'];

    protected $casts = [
        'metadata' => 'array'
    ];

    function folder(): BelongsTo
    {
        return $this->belongsTo(Folder::class);
    }

    public function getIcon(): string
    {
        return match ($this->type) {
            MessageType::TEXT->name => '📝',
            MessageType::PHOTO->name => '🖼️',
            MessageType::VIDEO->name => '🎥',
            MessageType::DOCUMENT->name => '📄',
            MessageType::AUDIO->name => '🎵',
            default => '📎',
        };
    }
}
