<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Foundation\Auth\User as Authenticatable;

class User extends Authenticatable
{
    protected $fillable = ['telegram_id', 'username', 'first_name', 'last_name'];

    protected function casts(): array
    {
        return [
            'is_admin' => 'boolean',
        ];
    }


    function folders(): BelongsToMany
    {
        return $this->belongsToMany(Folder::class);
    }

    function hasAccessToFolder($folderId): bool
    {
        return $this->folders()->where('folders.id', $folderId)->exists();
    }
}
