<?php

namespace App\Telegram\Menus\Admin;

use App\Models\Asset;
use SergiX44\Nutgram\Conversations\Conversation;
use SergiX44\Nutgram\Nutgram;

class DeleteAssetConversation extends Conversation
{
    use Helpers;


    public function start(Nutgram $bot): void
    {
        if (!self::authorizeAdmin($bot, $this)) return;


        $bot->sendMessage('Please send the asset ID to delete: ');


        $this->next('deleteTheAsset');
    }

    function deleteTheAsset(Nutgram $bot)
    {
        $assetId = trim($bot->message()->text ?? '');
        $asset = Asset::find($assetId);

        if (!$asset) {
            $bot->sendMessage('❌ Asset not found!');
            $this->start($bot);
            return;
        }

        $assetTitle = $asset->title;
        $asset->delete();

        $bot->sendMessage("✅ Asset '{$assetTitle}' has been deleted successfully.");
        AssetsMenu::begin($bot);
    }
}
