<?php

namespace App\Telegram\Menus\Admin;

use App\Models\User;
use SergiX44\Nutgram\Conversations\InlineMenu;
use SergiX44\Nutgram\Nutgram;
use SergiX44\Nutgram\Telegram\Types\Keyboard\InlineKeyboardButton;

class UsersMenu extends InlineMenu
{
    use Helpers;

    public function start(Nutgram $bot): void
    {
        if (!self::authorizeAdmin($bot, $this)) return;


        $users = User::withCount('folders')->orderBy('created_at', 'desc')->get();
        $text = "👥 <b>User Management</b>\n\nTotal users: " . $users->count() . "\n\n";

        if ($users->isNotEmpty()) {
            foreach ($users as $user) {
                $text .= "• " . htmlspecialchars($user->first_name)
                    . ($user->username ? " (@".htmlspecialchars($user->username).")" : '')
                    . " - ID: <code>{$user->telegram_id}</code>"
                    . " - Folders: {$user->folders_count}\n";
            }
        } else {
            $text .= "No users found.";
        }

        $this->menuText($text, ['parse_mode' => 'HTML'])
            ->addButtonRow(InlineKeyboardButton::make('⬅️ Back', callback_data: 'back@goBack'))
            ->showMenu();
    }

    public function goBack(Nutgram $bot): void
    {
        $this->end();
        AdminMenu::begin($bot);
    }
}
