@extends('layouts.admin')

@section('content')
    <h1>🔐 Grant Access</h1>
    <form action="{{ route('admin.folders.grant.access') }}" method="POST">
        @csrf
        <div class="mb-3">
            <label for="folder_id" class="form-label">Select Folder</label>
            <select class="form-select" id="folder_id" disabled>
                @if($folder)
                    <option value="{{ $folder->id }}">{{ $folder->getPath() }}</option>
                    <input type="hidden" name="folder_id" value="{{ $folder->id }}">
                @endif
            </select>
        </div>

        <div class="mb-3">
            <label for="telegram_ids" class="form-label">
                <i class="bi bi-person-plus me-1"></i> Telegram IDs
            </label>
            <textarea
                    id="telegram_ids"
                    name="telegram_ids"
                    class="form-control"
                    rows="3"
                    required>{{ old('telegram_ids') }}</textarea>
            <div class="form-text">
                Enter multiple Telegram IDs, separated by commas, spaces, or new lines.
            </div>
        </div>


        <a href="{{ route('admin.folders.index', ['folder_id=' . ($_GET['parent_id'] ?? '') ]) }}" class="btn btn-secondary">⬅️ Back</a>
        <button type="submit" class="btn btn-success">Grant Access</button>
    </form>
@endsection
