<?php

use App\Http\Controllers\AssetController;
use App\Http\Controllers\FolderController;
use App\Http\Controllers\TelegramBroadcastController;
use Illuminate\Support\Facades\Route;

Route::get('/', function () {
    return "Working just fine!";
});


Route::prefix('admin')
    ->name('admin.')
    ->group(function () {
        Route::get('/folders', [FolderController::class, 'index'])->name('folders.index');

        Route::post('/folders/update-order', [FolderController::class, 'updateOrder'])->name('folders.updateOrder');
        Route::post('/assets/update-order', [AssetController::class, 'updateOrder'])->name('assets.updateOrder');

        Route::get('/assets/{asset}/delete', [AssetController::class, 'confirmDelete'])->name('assets.confirmDelete');
        Route::delete('/assets/{asset}', [AssetController::class, 'destroy'])->name('assets.destroy');

        Route::get('/folders/create', [FolderController::class, 'create'])->name('folders.create');
        Route::post('/folders', [FolderController::class, 'store'])->name('folders.store');

        Route::get('/folders/{folder}/delete', [FolderController::class, 'confirmDelete'])->name('folders.confirmDelete');
        Route::delete('/folders/{folder}', [FolderController::class, 'destroy'])->name('folders.destroy');

        Route::get('/folders/grant', [FolderController::class, 'showGrantForm'])->name('folders.grant.form');
        Route::post('/folders/grant', [FolderController::class, 'grantAccess'])->name('folders.grant.access');

        Route::get('/folders/revoke', [FolderController::class, 'showRevokeForm'])->name('folders.revoke.form');
        Route::post('/folders/revoke', [FolderController::class, 'revokeAccess'])->name('folders.revoke.access');




        Route::get('/telegram-broadcast', [TelegramBroadcastController::class, 'index'])->name('broadcast.index');
        Route::post('/telegram-broadcast', [TelegramBroadcastController::class, 'broadcast'])->name('broadcast.send');
    });
