<?php $__env->startSection('content'); ?>
    <h1>➕ Create New Folder</h1>
    <form action="<?php echo e(route('admin.folders.store')); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <div class="mb-3">
            <label for="name" class="form-label">Folder Name</label>
            <input type="text" class="form-control" id="name" name="name" required>
        </div>

        <div class="mb-3">
            <label for="description" class="form-label">Folder Description (Optional)</label>
            <input type="text" class="form-control" id="description" name="description">
        </div>

        <div class="mb-3">
            <label for="parent_id" class="form-label">Parent Folder</label>
            <select class="form-select" id="parent_id" disabled>
                <?php if($parentFolder): ?>
                    <option value="<?php echo e($parentFolder->id); ?>"><?php echo e($parentFolder->getPath()); ?></option>
                    <input type="hidden" name="parent_id" value="<?php echo e($parentFolder->id); ?>">
                <?php else: ?>
                    <option value="">-- None (Root Folder) --</option>
                <?php endif; ?>
            </select>
        </div>
        <a href="<?php echo e(route('admin.folders.index', ['folder_id=' . ($_GET['parent_id'] ?? '') ])); ?>" class="btn btn-secondary">⬅️ Back</a>
        <button type="submit" class="btn btn-primary">Create Folder</button>
    </form>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/kurdevsv/public_html/resources/views/admin/folders/create.blade.php ENDPATH**/ ?>